﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7.Class;

namespace Winfoot_7
{
    public partial class MenuItemControl : UserControl
    {
        public delegate void DItemClick(object sender, WinfootMenuItem menuItem);
        /// <summary>
        /// アイテムクリックに対するイベントハンドラ。
        /// </summary>
        public event DItemClick ItemClick;

        public MenuItemControl(IMenuItem menuItem)
        {
            InitializeComponent();
            this.Tag = menuItem;
            label1.Text = menuItem.Text;
            pictureBox1.Image = menuItem.Image;
        }

        

        //このコントロールがクリックされたとき
        private void ItemClicked(object sender, EventArgs e)
        {
            if(ItemClick!=null)
            {
                ItemClick(sender, ((WinfootMenuItem)this.Tag));
            }
        }

        private void MenuItemControl_Paint(object sender, PaintEventArgs e)
        {
            Graphics graphics = this.CreateGraphics();
            graphics.DrawLine(Pens.Gray,new Point(0,this.Height-1),new Point(this.Width,this.Height-1) );
            graphics.Dispose();
        }
    }
}
